/*------------------------------------------------------------------------------*
 * File Name: PassingDouble.c 													*
 * Creation: 																	*
 * Purpose: Example on passing a double to a NAG function						*
 * Copyright (c) OriginLab Corp. 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010	*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
#include <Origin.h>
#include <OC_nag8.h>	// Header file for NAG library
// Note: The above header file does not include all the NAG library header files
// More header files can be added from the Origin C\System\NAG8 subfolder, such as:
// #include <NAG8\nagf07.h>


////////////////////////////////////////////////////////////////////////////////////
// This example calls a NAG function that accepts and returns a double
//
void test_nag1()
{
	double rm, x, xmu, xsig, z;
	x=-2;
	xmu=1;
	xsig=2.5;
	z = (x - xmu) / xsig;
	rm = nag_mills_ratio(z) / xsig;
	printf("The reciprocal of Mills Ratio = %f\n", rm);

}
